Vue.http.options.emulateJSON = true;
var appWeddings = new Vue({
    el: '#boda',
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,
        array_weedings: [],
        table_weddings: "",
    },
    created: function() {},
    mounted: function() {
        this.loadTableWeddings();
    },
    methods: {
        loadTableWeddings: function() {
            var that = this;
            this.table_weddings = $('#table-weddings').DataTable({
                language: {url:"//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"},
                order: [[ 0, "desc" ]],
                "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
                scrollY:        "320px",
                scrollCollapse: true,
                destroy: true,
                ajax: {
                    "url": this.rmt_url + "/boda/getWeddings",
                    "dataSrc": function(json) {
                        that.array_weedings = json;
                        return json;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                columnDefs: [{
                    targets: 0,
                    data: "id",
                    width: "10%"
                }, {
                    targets: 1,
                    render: function(data, type, row, meta) {
                        return row.novia + " & " + row.novio;
                    }
                }, {
                    targets: 2,
                    defaultContent: "Sin registro",
                    data: "idHotel.nombre_hotel"
                }, {
                    targets: 3,
                    render: function(data, type, row, meta) {
                        return moment(row.fecha_boda).format("DD/MM/YYYY");
                    }
                }, {
                    
                    targets: -1,
                    width: "10%",
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return '<a href="' + that.rmt_url + '/boda/' + row.id + '">' + feather.icons.eye.toSvg({
                            class: "font-small-4"
                        }) + '</a><a href="javascript:;" class="edit-record ml-icon" data-toggle="modal" data-target="#modal-cu-wedding" data-boda="' + row.id + '">' + feather.icons.edit.toSvg({
                            class: "font-small-4"
                        }) + '</a><a href="javascript:;" class="delete-record ml-icon" data-boda="' + row.id + '">' + feather.icons["trash-2"].toSvg({
                            class: "font-small-4"
                        }) + '</a><a href="' +row.url+'miboda/' + row.slug +'" class="ml-icon" target="_blank">' + feather.icons.globe.toSvg({
                            class: "font-small-4"
                        }) + '</a>';
                    }
                }]
            });
            $("div.head-label").html('<h6 class="mb-0">DataTable with Buttons</h6>');
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
    }
});
