Vue.http.options.emulateJSON = true;

var appModalUser = new Vue({
    el: '#modal-cu-user',
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,
        show_pwd: false,
        action: "create",

        model_user: {
            id: 0,
            username: "",
            password: "",
            email: "",
            superuser: 0,
            status: 1,
        },
        model_profile: {
            lastname: "",
            firstname: "",
        }
    },
    created: function() {},
    mounted: function() {},
    methods: {
        createUser: function() {
            delete this.model_user.id;
            var form_data = new FormData();
            var that = this;

            for (var key in this.model_user) {
                form_data.append("user[" + key + "]", that.model_user[key]);
            }
            form_data.append("profile[firstname]", this.model_profile["firstname"]);
            form_data.append("profile[lastname]", this.model_profile["lastname"]);

            this.$http.post(this.rmt_url + "/users/create", form_data).then(function(response) {
                $('#modal-cu-user').modal('hide');
                var response_var = response.body;
                if (response_var.id) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se ha creado un registro con la información proporcionada.'
                    });
                    appUsers.table_users.ajax.reload();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        },
        updateUser: function() {
            var form_data = new FormData();
            var that = this;
            delete this.model_user.userProfile;
            for (var key in this.model_user) {
                form_data.append("user[" + key + "]", that.model_user[key]);
            }
            form_data.append("profile[firstname]", this.model_profile["firstname"]);
            form_data.append("profile[lastname]", this.model_profile["lastname"]);
            this.$http.post(this.rmt_url + "/users/update", form_data).then(function(response) {
                $('#modal-cu-user').modal('hide');
                var response_var = response.body;
                if (response_var.id) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se han aplicado los cambios al registro del usuario.'
                    });
                    appUsers.table_users.ajax.reload();
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        },
        deleteUser: function() {
            Swal.fire({
                title: '¿Seguro?',
                text: "Cambiará el estatus del usuario a inactivo",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    this.$http.post(this.rmt_url + "/users/delete?id=" + this.model_user.id).then(function(response) {
                        var response_var = response.body;
                        Swal.fire({
                            icon: 'success',
                            title: 'Correcto',
                            text: 'Se ha cambiado el estatus del usuario.'
                        });
                        appUsers.table_users.ajax.reload();
                    }, function(ex) {
                        Swal.fire({
                            icon: 'error',
                            title: "¡Ops!",
                            html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                        });
                        console.log(ex.body);
                    });
                }
            });
        },
        clearModel: function() {
            this.model_user = {
                id: 0,
                username: "",
                password: "",
                email: "",
                superuser: 0,
                status: 1,
            };
            this.model_profile = {
                lastname: "",
                firstname: "",
            }
        }
    }
});

$("body").on("click", ".item-edit", function() {
    appModalUser.action = "update";
    var id_user = $(this).attr("data-user");
    var userFinded = appUsers.array_users.findIndex(x => x.id == id_user);
    appModalUser.model_user = appUsers.array_users[userFinded];
    appModalUser.model_profile = appModalUser.model_user.userProfile;
});

$("body").on("click", ".item-delete", function() {
    var id_user = $(this).attr("data-user");
    var userFinded = appUsers.array_users.findIndex(x => x.id == id_user);
    appModalUser.model_user = appUsers.array_users[userFinded];
    appModalUser.deleteUser();
});

$('#modal-cu-user').on('hidden.bs.modal', function(event) {
    appModalUser.action = "create";
    appModalUser.clearModel();
})

$(".form-password-toggle .input-group-text").on("click", (function(a) {
    a.preventDefault();
    var e = $(this),
        s = e.closest(".form-password-toggle"),
        n = e,
        o = s.find("input");
    "text" === o.attr("type") ? (o.attr("type", "password"),
        feather && n.find("svg").replaceWith(feather.icons.eye.toSvg({
            class: "font-small-4"
        }))) : "password" === o.attr("type") && (o.attr("type", "text"),
        feather && n.find("svg").replaceWith(feather.icons["eye-off"].toSvg({
            class: "font-small-4"
        })))
}))