Vue.http.options.emulateJSON = true;
var appUsers = new Vue({
    el: '#user',
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,

        array_users: [],
        table_users: "",
    },
    created: function() {},
    mounted: function() {
        this.loadTableUsers();
    },
    methods: {
        loadTableUsers: function() {
            var that = this;
            this.table_users = $('#table-users').DataTable({
                language: {url:"//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"},
                destroy: true,
                ajax: {
                    "url": this.rmt_url + "/users/getUsers",
                    "dataSrc": function(json) {
                        that.array_users = json.data;
                        return json.data;
                    }
                },
                dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                columnDefs: [{
                    targets: 0,
                    data: "id",
                }, {
                    targets: 1,
                    data: "userProfile.firstname"
                }, {
                    targets: 2,
                    data: "userProfile.lastname"
                }, {
                    targets: 3,
                    data: "email"
                }, {
                    targets: 4,
                    data: "username"
                }, {
                    targets: 5,
                    render: function(data, type, row, meta) {
                        return parseInt(row.superuser) ? "Si" : "No";
                    }
                }, {
                    targets: 6,
                    render: function(data, type, row, meta) {
                        return parseInt(row.status) ? "Activo" : "Inactivo";
                    }
                }, {
                    targets: -1,
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return '<a href="javascript:;" class="item-edit ml-1" data-user="' + row.id + '" data-toggle="modal" data-target="#modal-cu-user">' + feather.icons.edit.toSvg({
                            class: "font-small-4"
                        }) + '</a><a href="javascript:;" class="item-delete ml-1" data-user="' + row.id + '">' + feather.icons["trash-2"].toSvg({
                            class: "font-small-4"
                        }) + '</a>';
                    }
                }]
            });
            // $("div.head-label").html('<h6 class="mb-0">DataTable with Buttons</h6>');
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
    }
});