Vue.http.options.emulateJSON = true;
var appWeddings = new Vue({
    el: '#account-vertical-general',
    data: {
        rmt_url: baseUrl,
        loaded: false,
        showing: false,

        model_user: {},
    },
    created: function() {},
    mounted: function() {
        this.loadInfoUser();
    },
    methods: {
        loadInfoUser: function() {
            this.$http.get(this.rmt_url + "/users/getInfoUser").then(function(response) {
                var response_var = response.body;
                this.model_user = response_var;
                this.loaded = true;
            }, function(ex) {
                console.log(ex.body);
            });
        },
        applyChanges: function() {
            var form_data = new FormData();
            form_data.append("username", this.model_user.username);
            form_data.append("email", this.model_user.email);
            form_data.append("firstname", this.model_user.userProfile.firstname);
            form_data.append("lastname", this.model_user.userProfile.lastname);

            this.$http.post(this.rmt_url + "/users/editProfile", form_data).then(function(response) {
                var response_var = response.body;
                if (response_var.id) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se han guardado los cambios.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var) + "</pre></code>",
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        },
        changePassword: function() {
            var form_data = new FormData();
            var pwd = $("#account-new-password").val();
            form_data.append("pwd", btoa(pwd));
            this.$http.post(this.rmt_url + "/users/changePassword", form_data).then(function(response) {
                var response_var = response.body;
                if (response_var.id) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Correcto',
                        text: 'Se ha cambiado la contraseña.'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var) + "</pre></code>",
                    });
                }
            }, function(ex) {
                Swal.fire({
                    icon: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex.body) + "</pre></code>",
                });
                console.log(ex.body);
            });
        }
    }
});

$("body").on("click", "#pwd-change", function() {
    var new_pwd = $("#account-new-password").val()
    var confirm_pwd = $("#account-retype-new-password").val()
    if (new_pwd == confirm_pwd) {
        appWeddings.changePassword();
    } else {

    }
});

var e = $(".validate-form");
e.length && e.each((function() {
    var e = $(this);
    e.validate({
        rules: {
            "new-password": {
                required: !0,
                minlength: 6
            },
            "confirm-new-password": {
                required: !0,
                minlength: 6,
                equalTo: "#account-new-password"
            },
        }
    })
}))